*** COS 2018 12, last update 2022 12  
           
capture program drop dq_des_gc1  
program define dq_des_gc1, rclass  
syntax varlist (max=1 numeric) [if] [in], clustervar(varname numeric) [catgraphtype(int 1) percent(int 1)] 		///  
			$syntax_datasource_files  $syntax_variablelists														///  
			$syntax_reportformatting																			///  
			$syntax_analysissettings																			///  
			$syntax_debugging																					///  
			$technical_settings  
marksample touse, novarlist  
			        
			        
local indent=`indent'+5  
local adoname "dq_des_gc1"  
local text_i "di as text _n "  					  
local structure "`ststrata'_`stcluster'"  
local pointer "$`varlist'"														  
local graphtype="descgraph`percent'"  
local graph_path "`gd'/`graphtype'_`structure'_`varlist'.png"  
scalar graph_gc1_`structure'_`pointer'="`graph_path'"  
	          
	          
capture confirm file "`graph_path'"  
if _rc>0 | `forcecalc'~=0  {													  
	local outcome `varlist'  
	local ylab1_n ""  
	local ylab2_n ""  
	qui levelsof `outcome' if `clustervar'<. 			 						  
	local olevels=wordcount("`r(levels)'")										  
	local n=`olevels' 		 													  
	          
	if `olevels'==0   {  
		  dq_out_add ,  tablename(integtable_analysisconduct) row(integtablerows_analysisconduct) columns(3) colcontent1("$Warning_1") colcontent2("$Variable_1: `varlist' Cluster: `clustervar'") colcontent3($DQ_INTP_issue_6)  indent(`indent') 	  
		 exit    
	}         
	          
	 foreach l of local levels {  
		qui count if `outcome' == `l'  
		local N=r(N)  
		local ylab1_n =`"`ylab1_n' `n' "`l'" "'									  
		local ylab2_n =`"`ylab2_n' `n' "n=`N'" "'								  
		local n=`n'-1															  
	 }        
	local xlab1_n ""  
	local xlab2_n ""  
	local barstyle ""  
	local n=1																	  
	qui levelsof `clustervar', local(levels)  									  
	local clevels=wordcount("`r(levels)'")										  
	qui count if `clustervar'<.													  
	local observations=r(N)  
	 foreach l of local levels {  
		qui count if `clustervar' == `l'  
		local N=r(N)  
		local xlab1_n =`"`xlab1_n' `n' "`l'" "'									  
		local xlab2_n =`"`xlab2_n' `n' "n=`N'" "'								  
		local intensity=min(1,max((`N'/`observations'*`clevels')^0.3,0.1))		  
		local barcolor="emidblue"  
		local barstyle `"`barstyle' bar`n'(bcolor(`barcolor'*`intensity'))"'  
		local n=`n'+1  
	 }        
	          
	if `clevels'<10 {  
		local axis1_xlabelsize=6 	  
		local axis2_xlabelsize=5  
	}         
	if `clevels'<20 {  
		local axis1_xlabelsize=5 	  
		local axis2_xlabelsize=4  
	}         
	if `clevels'<30 {  
		local axis1_xlabelsize=4 	  
		local axis2_xlabelsize=3  
	}         
	if `clevels'<40 {  
		local axis1_xlabelsize=3 	  
		local axis2_xlabelsize=2  
	}		       
	if `clevels'>=40 {  
		local axis1_xlabelsize=1.5 	  
		local axis2_xlabelsize=1.5  
	}		       
	          
	dq_hlp_fmt, clusternumber(`clevels')  indent(`indent')  
	local gheight 			"`r(gheight)'"  
	local gwidth 			"`r(gwidth)'"  
	          
	if `percent'==0 local percentoutput "" 							  
	if `percent'==1 local percentoutput "percent(`clustervar')" 	  
	if `percent'==2 local percentoutput "percent(`outcome')" 		  
	          
	          
	if  `olevels' > `histkat' {  
		return local gc1graph=0  
		dq_ext_vp  `varlist' if `touse', over(`clustervar' ) legend(cols(1) position(9))  graphregion(margin(vsmall) 																			///  
					fcolor(white)) bar(color(red)) obs(alt)  median(color(green)) 																										///  
					yline(`=vp_mean_`ststrata'_`pointer'', lcolor(blue))  yline(`=vp_rm1l_`ststrata'_`pointer'', lcolor(blue) lpattern(dash)) yline(`=vp_rm1u_`ststrata'_`pointer'', lcolor(blue) lpattern(dash))  				///  
					title("Blue solid line: Mean; blue dashed line: Mean+/-SD; ", ring(0) position(5) box size(2) bcolor(white)) ytitle("", angle(vertical))  xlabel(`xlab1_n',angle(vertical)) 	///  
					`barstyle'  
	} 	       
	          
	if  `olevels' <= `histkat' {  
		return local gc1graph=1  
		if `catgraphtype'==2 {  
			lab var `varlist' "."  
			 catplot `varlist' if `touse', asyvars  over(`clustervar') blabel(bar, pos(right) format(%2.0f) orientation(horizontal) bexpand size(2)) legend(pos(bottom) rows(4) ) ///  
					graphregion(fcolor(white)) 															///  
					bar(1, bfcolor(emidblue) blcolor(emidblue)) 										///  
					bar(2, bfcolor(sand) blcolor(sand)) 												///  
					bar(3, bfcolor(ltbluishgray) blcolor(ltbluishgray))  								///  
					bar(4, bfcolor(eltgreen) blcolor(eltgreen)) ytitle("n") l1title("")  
			*lab var `varlist' "`vlmod`var''"	v42	  
			lab var `varlist' "`=varshortlabel_`pointer''"		  
		}        
		if `catgraphtype'~=2  {		  
			dq_ext_tp `outcome' `clustervar' if `touse', `percentoutput'		  						///  
					graphregion(fcolor(white) margin(vsmall))											///  
					showval (mlabsize(`axis2_xlabelsize') mlabangle(0) mlabcolor(emdblue)  )  			///  
					ytitle("") ytitle(, orient(hor)) 													///  
					xtitle("") 	 																		///  
					yaxis(2) ytitle("",axis(2))	 														///  
					ylabel(`ylab1_n',axis(1))															///  
					ylabel(`ylab2_n',axis(2) labsize(2) tlength(0))										///  
					xaxis(2)xtitle("",axis(2)) subtitle("")	 											///  
					xlabel(`xlab1_n', 			angle(90)  grid labsize(`axis1_xlabelsize'))  			///  
					xlabel(`xlab2_n' ,axis(2) 	angle(90)  grid labsize(`axis2_xlabelsize'))  	 		///  
					separate(`clustervar') `barstyle' 		  
		}	       
	}	        
	          
	qui graph export "`graph_path'", replace width(`gwidth') height(`gheight')  
	*graph save "`graph_path'", replace asis  
	          
}	         
end        
